<?php
/**
 * API Entry Point
 * เปลี่ยน config เป็น production
 */

// เปลี่ยน config เป็น production
require_once '../config/config.production.php';

// Route API requests
$request_uri = $_SERVER['REQUEST_URI'];
$path = parse_url($request_uri, PHP_URL_PATH);

// Remove /api from path
$path = str_replace('/api', '', $path);

// Route to appropriate API file
if (strpos($path, '/v1/personnel') !== false) {
    require_once 'v1/personnel.php';
} elseif (strpos($path, '/v1/auth') !== false) {
    require_once 'v1/auth.php';
} elseif (strpos($path, '/v1/import-export') !== false) {
    require_once 'v1/import-export.php';
} elseif (strpos($path, '/v1/install') !== false) {
    require_once 'v1/install.php';
} else {
    http_response_code(404);
    echo json_encode(['error' => 'API endpoint not found']);
}
?>
