# ระบบบริหารงานบุคคล โรงเรียนแม่สายประสิทธิ์ศาสตร์

ระบบเว็บแอปพลิเคชันสำหรับบริหารงานบุคคลในโรงเรียน พัฒนาด้วย PHP และ MySQL พร้อม Frontend ที่สวยงามและทันสมัย

## ✨ คุณสมบัติหลัก

### 🏠 **หน้าสาธารณะ**
- แสดงข้อมูลสรุปบุคลากรแบบ Real-time
- กราฟและสถิติที่สวยงาม
- ระบบค้นหาและกรองข้อมูล
- Responsive Design รองรับทุกอุปกรณ์

### 🔐 **ระบบผู้ดูแล**
- Dashboard แบบครบถ้วน
- จัดการข้อมูลบุคลากร (CRUD)
- ระบบ Import/Export ข้อมูล
- ระบบ Authentication และ Security
- บันทึกการใช้งาน (Audit Log)

### 📊 **การรายงาน**
- สถิติบุคลากรแบบ Real-time
- กราฟแสดงข้อมูลตามวิทยฐานะ
- รายงานการเปลี่ยนแปลงข้อมูล
- Export ข้อมูลเป็น Excel/CSV

## 🛠️ เทคโนโลยีที่ใช้

### Backend
- **PHP 7.4+** - ภาษาโปรแกรมหลัก
- **MySQL 5.7+** - ฐานข้อมูล
- **PDO** - การเชื่อมต่อฐานข้อมูล
- **RESTful API** - API สำหรับ Frontend

### Frontend
- **HTML5, CSS3, JavaScript** - หลัก
- **Chart.js** - กราฟและแผนภูมิ
- **Font Awesome** - ไอคอน
- **Google Fonts** - ฟอนต์ภาษาไทย

## 📁 โครงสร้างไฟล์

```
hrmps/
├── api/                    # API Backend
│   ├── index.php          # API Entry Point
│   └── v1/
│       ├── auth.php       # Authentication API
│       ├── personnel.php  # Personnel Management API
│       ├── import-export.php # Import/Export API
│       └── install.php    # Installation API
├── admin/                 # Admin Panel
│   ├── dashboard.html     # Dashboard
│   └── personnel-management.html # Personnel Management
├── config/                # Configuration
│   ├── config.php        # Main Config
│   ├── config.production.php # Production Config
│   └── database.php      # Database Config
├── database/             # Database
│   ├── schema.sql        # Database Schema
│   └── import_to_production.sql # Production Import
├── models/               # Data Models
│   ├── Personnel.php     # Personnel Model
│   └── User.php          # User Model
├── images/               # Images
├── styles.css           # Main Styles
├── script.js            # Main JavaScript
├── index.html           # Public Homepage
├── index.php            # Production Entry Point
├── login.html           # Login Page
├── install.php          # Installation Page
├── .htaccess            # Apache Configuration
├── composer.json        # Dependencies
└── README.md            # Documentation
```

## 🚀 การติดตั้ง

### ข้อกำหนดระบบ
- **PHP 7.4** หรือสูงกว่า
- **MySQL 5.7** หรือสูงกว่า
- **Apache/Nginx** Web Server
- **cPanel** (สำหรับ Hosting)

### ข้อมูลการเชื่อมต่อฐานข้อมูล
- **Server:** localhost:3306
- **Database:** cp117896_hr
- **Username:** cp117896_hr
- **Password:** wB1[epS^cDKj

### ขั้นตอนการติดตั้ง

#### 1. อัปโหลดไฟล์
อัปโหลดไฟล์ทั้งหมดไปยัง root directory ของ `hr.maesai.ac.th`

#### 2. นำเข้าฐานข้อมูล
1. เข้าไปที่ [phpMyAdmin](https://cpanel03wh.bkk1.cloud.z.com:2083/cpsess6252302616/3rdparty/phpMyAdmin/)
2. เลือกฐานข้อมูล `cp117896_hr`
3. ไปที่แท็บ "Import"
4. อัปโหลดไฟล์ `database/import_to_production.sql`
5. กด "Go" เพื่อนำเข้าข้อมูล

#### 3. ตั้งค่า Permissions
```bash
# ตั้งค่า permissions สำหรับโฟลเดอร์ uploads
chmod 755 uploads/
chmod 644 config/*.php
chmod 644 models/*.php
chmod 644 api/v1/*.php
```

#### 4. ทดสอบระบบ
1. ไปที่ `https://hr.maesai.ac.th/`
2. ควรเห็นหน้าสาธารณะแสดงข้อมูลครู
3. ไปที่ `https://hr.maesai.ac.th/login.html`
4. เข้าสู่ระบบด้วย:
   - **Username:** admin
   - **Password:** admin123

## 🔒 ความปลอดภัย

### 1. เปลี่ยนรหัสผ่านเริ่มต้น
```sql
-- เปลี่ยนรหัสผ่าน admin
UPDATE users SET password = '$2y$10$new_hashed_password' WHERE username = 'admin';
```

### 2. ตั้งค่า HTTPS
- ใช้ SSL Certificate
- Redirect HTTP ไปยัง HTTPS

### 3. ตั้งค่า Firewall
- จำกัดการเข้าถึงจาก IP ที่ไม่รู้จัก
- ใช้ Fail2Ban สำหรับป้องกัน Brute Force

## 📊 การสำรองข้อมูล

### สำรองฐานข้อมูล
```bash
# สำรองฐานข้อมูล
mysqldump -u cp117896_hr -p cp117896_hr > backup_$(date +%Y%m%d).sql

# กู้คืนฐานข้อมูล
mysql -u cp117896_hr -p cp117896_hr < backup_20240101.sql
```

### สำรองไฟล์
```bash
# สำรองไฟล์ทั้งหมด
tar -czf backup_$(date +%Y%m%d).tar.gz /path/to/hr/
```

## 🐛 การแก้ไขปัญหา

### ปัญหาการเชื่อมต่อฐานข้อมูล
1. ตรวจสอบข้อมูลการเชื่อมต่อใน `config/config.production.php`
2. ตรวจสอบว่า MySQL Server ทำงานอยู่
3. ตรวจสอบสิทธิ์ผู้ใช้ฐานข้อมูล

### ปัญหาการอัปโหลดไฟล์
1. ตรวจสอบ permissions ของโฟลเดอร์ `uploads/`
2. ตรวจสอบ `upload_max_filesize` ใน php.ini
3. ตรวจสอบ `post_max_size` ใน php.ini

### ปัญหา API ไม่ทำงาน
1. ตรวจสอบ URL Rewriting
2. ตรวจสอบ .htaccess file
3. ตรวจสอบ error logs

## 📞 การสนับสนุน

### ติดต่อผู้พัฒนา
- **Email:** detphong@example.com
- **GitHub:** [Repository Link]

### การรายงานปัญหา
1. ตรวจสอบ Error Logs
2. บันทึกขั้นตอนที่ทำให้เกิดปัญหา
3. ส่งรายงานพร้อม Screenshot

## 📝 Changelog

### Version 1.0.0 (2024-01-01)
- เปิดตัวระบบครั้งแรก
- ระบบจัดการบุคลากรพื้นฐาน
- ระบบ Authentication
- ระบบ Import/Export
- Dashboard สำหรับผู้ดูแล

## 📄 License

ระบบนี้พัฒนาสำหรับโรงเรียนแม่สายประสิทธิ์ศาสตร์
© 2024 โรงเรียนแม่สายประสิทธิ์ศาสตร์

---

**หมายเหตุ:** ระบบนี้พัฒนาขึ้นเพื่อใช้ในการบริหารงานบุคคลของโรงเรียนเท่านั้น กรุณาอย่าแจกจ่ายหรือใช้ในเชิงพาณิชย์โดยไม่ได้รับอนุญาต
