<?php
/**
 * ระบบติดตั้งระบบบริหารงานบุคคล
 * โรงเรียนแม่สายประสิทธิ์ศาสตร์
 */

// ตั้งค่า Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ตั้งค่า Timezone
date_default_timezone_set('Asia/Bangkok');

?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ติดตั้งระบบ - ระบบบริหารงานบุคคล โรงเรียนแม่สายประสิทธิ์ศาสตร์</title>
    <link href="https://fonts.googleapis.com/css2?family=Sarabun:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Sarabun', sans-serif;
            background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .install-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            max-width: 800px;
            width: 100%;
            overflow: hidden;
        }
        
        .install-header {
            background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 100%);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        
        .install-logo {
            max-width: 100px;
            max-height: 100px;
            border-radius: 15px;
            margin-bottom: 1rem;
            background: rgba(255, 255, 255, 0.9);
            padding: 1rem;
        }
        
        .install-title {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .install-subtitle {
            font-size: 1.1rem;
            opacity: 0.9;
        }
        
        .install-content {
            padding: 2rem;
        }
        
        .step {
            margin-bottom: 2rem;
            padding: 1.5rem;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            transition: all 0.3s ease;
        }
        
        .step.success {
            border-color: #4CAF50;
            background: rgba(76, 175, 80, 0.05);
        }
        
        .step.error {
            border-color: #F44336;
            background: rgba(244, 67, 54, 0.05);
        }
        
        .step-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }
        
        .step-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            color: white;
        }
        
        .step-icon.default {
            background: #6c757d;
        }
        
        .step-icon.success {
            background: #4CAF50;
        }
        
        .step-icon.error {
            background: #F44336;
        }
        
        .step-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: #333;
        }
        
        .step-description {
            color: #666;
            margin-bottom: 1rem;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            color: #333;
            font-weight: 500;
        }
        
        .form-input {
            width: 100%;
            padding: 0.75rem;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 1rem;
            font-family: 'Sarabun', sans-serif;
            transition: border-color 0.3s ease;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #1B5E20;
            box-shadow: 0 0 0 3px rgba(27, 94, 32, 0.1);
        }
        
        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 100%);
            color: white;
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, #2E7D32 0%, #388E3C 100%);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(27, 94, 32, 0.3);
        }
        
        .btn-success {
            background: #4CAF50;
            color: white;
        }
        
        .btn-success:hover {
            background: #45a049;
        }
        
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }
        
        .alert-success {
            background: rgba(76, 175, 80, 0.1);
            color: #2e7d32;
            border: 1px solid rgba(76, 175, 80, 0.3);
        }
        
        .alert-error {
            background: rgba(244, 67, 54, 0.1);
            color: #c62828;
            border: 1px solid rgba(244, 67, 54, 0.3);
        }
        
        .alert-info {
            background: rgba(33, 150, 243, 0.1);
            color: #1565c0;
            border: 1px solid rgba(33, 150, 243, 0.3);
        }
        
        .progress-bar {
            width: 100%;
            height: 8px;
            background: #e0e0e0;
            border-radius: 4px;
            overflow: hidden;
            margin-bottom: 1rem;
        }
        
        .progress-fill {
            height: 100%;
            background: linear-gradient(135deg, #1B5E20 0%, #2E7D32 100%);
            transition: width 0.3s ease;
        }
        
        .hidden {
            display: none;
        }
        
        .text-center {
            text-align: center;
        }
        
        .mt-2 {
            margin-top: 1rem;
        }
        
        .mb-2 {
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <div class="install-header">
            <img src="https://www.maesai.ac.th/web/wp-content/uploads/2024/06/images.png" 
                 alt="โลโก้โรงเรียนแม่สายประสิทธิ์ศาสตร์" 
                 class="install-logo"
                 onerror="this.style.display='none';">
            <h1 class="install-title">ติดตั้งระบบบริหารงานบุคคล</h1>
            <p class="install-subtitle">โรงเรียนแม่สายประสิทธิ์ศาสตร์</p>
        </div>
        
        <div class="install-content">
            <div class="progress-bar">
                <div class="progress-fill" id="progressFill" style="width: 0%"></div>
            </div>
            
            <div id="step1" class="step">
                <div class="step-header">
                    <div class="step-icon default" id="step1Icon">
                        <i class="fas fa-check"></i>
                    </div>
                    <h3 class="step-title">ตรวจสอบระบบ</h3>
                </div>
                <p class="step-description">ตรวจสอบความพร้อมของระบบและ PHP</p>
                <div id="step1Content">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        กำลังตรวจสอบระบบ...
                    </div>
                </div>
            </div>
            
            <div id="step2" class="step">
                <div class="step-header">
                    <div class="step-icon default" id="step2Icon">
                        <i class="fas fa-database"></i>
                    </div>
                    <h3 class="step-title">ตั้งค่าฐานข้อมูล</h3>
                </div>
                <p class="step-description">กรอกข้อมูลการเชื่อมต่อฐานข้อมูล</p>
                <div id="step2Content" class="hidden">
                    <form id="databaseForm">
                        <div class="form-group">
                            <label for="dbHost" class="form-label">Host</label>
                            <input type="text" id="dbHost" name="dbHost" class="form-input" value="localhost" required>
                        </div>
                        <div class="form-group">
                            <label for="dbName" class="form-label">ชื่อฐานข้อมูล</label>
                            <input type="text" id="dbName" name="dbName" class="form-input" value="hr_maesai" required>
                        </div>
                        <div class="form-group">
                            <label for="dbUser" class="form-label">ชื่อผู้ใช้</label>
                            <input type="text" id="dbUser" name="dbUser" class="form-input" required>
                        </div>
                        <div class="form-group">
                            <label for="dbPass" class="form-label">รหัสผ่าน</label>
                            <input type="password" id="dbPass" name="dbPass" class="form-input">
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-database"></i>
                            ทดสอบการเชื่อมต่อ
                        </button>
                    </form>
                </div>
            </div>
            
            <div id="step3" class="step">
                <div class="step-header">
                    <div class="step-icon default" id="step3Icon">
                        <i class="fas fa-cogs"></i>
                    </div>
                    <h3 class="step-title">สร้างฐานข้อมูล</h3>
                </div>
                <p class="step-description">สร้างตารางและข้อมูลเริ่มต้น</p>
                <div id="step3Content" class="hidden">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        กำลังสร้างฐานข้อมูล...
                    </div>
                    <button id="createDbBtn" class="btn btn-primary hidden">
                        <i class="fas fa-plus"></i>
                        สร้างฐานข้อมูล
                    </button>
                </div>
            </div>
            
            <div id="step4" class="step">
                <div class="step-header">
                    <div class="step-icon default" id="step4Icon">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <h3 class="step-title">ตั้งค่าผู้ดูแลระบบ</h3>
                </div>
                <p class="step-description">สร้างบัญชีผู้ดูแลระบบ</p>
                <div id="step4Content" class="hidden">
                    <form id="adminForm">
                        <div class="form-group">
                            <label for="adminUsername" class="form-label">ชื่อผู้ใช้</label>
                            <input type="text" id="adminUsername" name="adminUsername" class="form-input" value="admin" required>
                        </div>
                        <div class="form-group">
                            <label for="adminPassword" class="form-label">รหัสผ่าน</label>
                            <input type="password" id="adminPassword" name="adminPassword" class="form-input" required>
                        </div>
                        <div class="form-group">
                            <label for="adminEmail" class="form-label">อีเมล</label>
                            <input type="email" id="adminEmail" name="adminEmail" class="form-input" required>
                        </div>
                        <div class="form-group">
                            <label for="adminName" class="form-label">ชื่อ-นามสกุล</label>
                            <input type="text" id="adminName" name="adminName" class="form-input" required>
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-user-plus"></i>
                            สร้างบัญชีผู้ดูแล
                        </button>
                    </form>
                </div>
            </div>
            
            <div id="step5" class="step">
                <div class="step-header">
                    <div class="step-icon default" id="step5Icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <h3 class="step-title">ติดตั้งเสร็จสิ้น</h3>
                </div>
                <p class="step-description">ระบบพร้อมใช้งานแล้ว</p>
                <div id="step5Content" class="hidden">
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <strong>ติดตั้งสำเร็จ!</strong> ระบบบริหารงานบุคคลพร้อมใช้งานแล้ว
                    </div>
                    <div class="text-center mt-2">
                        <a href="login.html" class="btn btn-success">
                            <i class="fas fa-sign-in-alt"></i>
                            เข้าสู่ระบบ
                        </a>
                        <a href="index.html" class="btn btn-primary">
                            <i class="fas fa-home"></i>
                            หน้าหลัก
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        let currentStep = 1;
        let dbConfig = {};

        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            checkSystemRequirements();
        });

        // Check system requirements
        async function checkSystemRequirements() {
            try {
                const response = await fetch('api/v1/install.php?action=check');
                const data = await response.json();
                
                if (data.success) {
                    updateStep(1, 'success', data.message);
                    showStep(2);
                } else {
                    updateStep(1, 'error', data.message);
                }
            } catch (error) {
                updateStep(1, 'error', 'ไม่สามารถตรวจสอบระบบได้');
            }
        }

        // Database form submission
        document.getElementById('databaseForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            dbConfig = Object.fromEntries(formData);
            
            try {
                const response = await fetch('api/v1/install.php?action=test-db', {
                    method: 'POST',
                    body: JSON.stringify(dbConfig),
                    headers: {
                        'Content-Type': 'application/json'
                    }
                });
                
                const data = await response.json();
                
                if (data.success) {
                    updateStep(2, 'success', 'เชื่อมต่อฐานข้อมูลสำเร็จ');
                    showStep(3);
                } else {
                    updateStep(2, 'error', data.message);
                }
            } catch (error) {
                updateStep(2, 'error', 'ไม่สามารถเชื่อมต่อฐานข้อมูลได้');
            }
        });

        // Create database
        document.getElementById('createDbBtn').addEventListener('click', async function() {
            try {
                const response = await fetch('api/v1/install.php?action=create-db', {
                    method: 'POST',
                    body: JSON.stringify(dbConfig),
                    headers: {
                        'Content-Type': 'application/json'
                    }
                });
                
                const data = await response.json();
                
                if (data.success) {
                    updateStep(3, 'success', 'สร้างฐานข้อมูลสำเร็จ');
                    showStep(4);
                } else {
                    updateStep(3, 'error', data.message);
                }
            } catch (error) {
                updateStep(3, 'error', 'ไม่สามารถสร้างฐานข้อมูลได้');
            }
        });

        // Admin form submission
        document.getElementById('adminForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const adminData = Object.fromEntries(formData);
            
            try {
                const response = await fetch('api/v1/install.php?action=create-admin', {
                    method: 'POST',
                    body: JSON.stringify({...dbConfig, ...adminData}),
                    headers: {
                        'Content-Type': 'application/json'
                    }
                });
                
                const data = await response.json();
                
                if (data.success) {
                    updateStep(4, 'success', 'สร้างบัญชีผู้ดูแลสำเร็จ');
                    showStep(5);
                } else {
                    updateStep(4, 'error', data.message);
                }
            } catch (error) {
                updateStep(4, 'error', 'ไม่สามารถสร้างบัญชีผู้ดูแลได้');
            }
        });

        // Update step status
        function updateStep(step, status, message) {
            const stepElement = document.getElementById(`step${step}`);
            const iconElement = document.getElementById(`step${step}Icon`);
            const contentElement = document.getElementById(`step${step}Content`);
            
            stepElement.className = `step ${status}`;
            iconElement.className = `step-icon ${status}`;
            
            if (status === 'success') {
                iconElement.innerHTML = '<i class="fas fa-check"></i>';
            } else if (status === 'error') {
                iconElement.innerHTML = '<i class="fas fa-times"></i>';
            }
            
            // Show message
            const alertClass = status === 'success' ? 'alert-success' : 'alert-error';
            contentElement.innerHTML = `
                <div class="alert ${alertClass}">
                    <i class="fas fa-${status === 'success' ? 'check-circle' : 'exclamation-triangle'}"></i>
                    ${message}
                </div>
            `;
        }

        // Show step
        function showStep(step) {
            document.getElementById(`step${step}Content`).classList.remove('hidden');
            updateProgress(step * 20);
        }

        // Update progress
        function updateProgress(percentage) {
            document.getElementById('progressFill').style.width = percentage + '%';
        }
    </script>
</body>
</html>
